<%@ Page language="c#" Codebehind="WF_Admin.aspx.cs" AutoEventWireup="false" Inherits="ActiveDataOnline.WebForum.WF_Admin" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<!-- Note:	Be careful not to remove or alter ASP.NET or server-side tags, otherwise the application might not work properly. -->
<!--				But, feel free to add HTML to the page and/or change style sheet settings, and the like. -->
<html>
	<head>
		<meta name="AUTHOR" content="Active Data Online Pty Ltd">
		<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" Content="C#">
		<meta name="vs_defaultClientScript" content="JavaScript (ECMAScript)">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
		<title runat="server" id="PageTitle" />
		<link rel="stylesheet" href="WF_Styles.css" type="text/css">
	</head>
	<body MS_POSITIONING="GridLayout">
		<table border="0" width="100%" id="Header">
			<tr valign="top">
				<td align="left">
					<h1 id="H1PageTitle" runat="server" />
					<asp:label id="ActiveUsers" cssclass="small" runat="server" />
				</td>
				<td align="right">
					<asp:label id="WelcomeMember" cssclass="small" font-bold="True" runat="server" />
					<p class="small">
						<a href="WF_Index.aspx">Home</a>&nbsp;|&nbsp;<asp:hyperlink id="MenuLogin" navigateurl="WF_Login.aspx" text="Login" runat="server" /><asp:label id="LoginSpace" runat="server" /><asp:hyperlink id="MenuRegister" navigateurl="WF_Register.aspx" text="Register" runat="server" /><asp:label id="RegisterSpace" runat="server" /><a href="WF_News.aspx">News</a>&nbsp;|&nbsp;<a href="WF_Search.aspx">Search</a>&nbsp;|&nbsp;<a href="WF_Members.aspx">Members</a><asp:label id="SettingsSpace" runat="server" /><asp:hyperlink id="MenuSettings" navigateurl="WF_Settings.aspx" text="Settings" runat="server" /><asp:label id="AdminSpace" runat="server" /><asp:hyperlink id="MenuAdmin" navigateurl="WF_Admin.aspx" text="Administer" runat="server" />
					</p>
				</td>
			</tr>
		</table>
		<h2>
			Administer
		</h2>
		<ul>
			<asp:Panel ID="LinkForumsPanel" Visible="True" Runat="server">
				<li>
					<asp:hyperlink id="AdministerForums" text="Forums" navigateurl="WF_Admin.aspx?area=forums" runat="server" />
				</li>
			</asp:Panel>
			<asp:Panel ID="LinkTopicsPanel" Visible="True" Runat="server">
				<li>
					<asp:hyperlink id="AdministerTopics" text="Topics" navigateurl="WF_Admin.aspx?area=topics" runat="server" />
				</li>
			</asp:Panel>
			<asp:Panel ID="LinkIconsPanel" Visible="True" Runat="server">
				<li>
					<asp:hyperlink id="AdministerIcons" text="Icons" navigateurl="WF_Admin.aspx?area=icons" runat="server" />
				</li>
			</asp:Panel>
			<asp:Panel ID="LinkMembersPanel" Visible="True" Runat="server">
				<li>
					<asp:hyperlink id="AdministerMembers" text="Members" navigateurl="WF_Admin.aspx?area=members" runat="server" />
				</li>
			</asp:Panel>
			<asp:Panel ID="LinkBannedWordsPanel" Visible="True" Runat="server">
				<li>
					<asp:hyperlink id="AdministerBannedWords" text="Banned words" navigateurl="WF_Admin.aspx?area=bannedwords" runat="server" />
				</li>
			</asp:Panel>
		</ul>
		<hr size="1">
		<asp:panel id="ForumsPanel" runat="server">
			<form id="AdministerForumsForm" name="AdministerForumsForm" runat="server" action="WF_Admin.aspx?area=forums" method="post">
				<h2>
					Forums
				</h2>
				<asp:label id="ErrorInformationForums" cssclass="error" visible="False" runat="server" />
				<table border="0" width="100%" cellspacing="5">
					<tr valign="top">
						<td>
							Current forum:
						</td>
						<td colspan="2">
							<asp:dropdownlist id="ForumsList" cssclass="forminput" datatextfield="formattedForumDescription" datavaluefield="fldForumID" onselectedindexchanged="SelectForum" autopostback="True" runat="server" />
						</td>
					</tr>
					<tr valign="top">
						<td width="20%">
							Forum name:
						</td>
						<td width="40%">
							<asp:textbox id="ForumNameInput" cssclass="forminput" tooltip="Forum name" width="300" maxlength="50" runat="server" />
						</td>
						<td width="40%">
							<asp:requiredfieldvalidator id="ForumNameRequired" cssclass="validator" controltovalidate="ForumNameInput" display="dynamic" errormessage="To proceed, please enter a forum name." runat="server" />
							<asp:regularexpressionvalidator id="ForumNameInvalidChars" cssclass="validator" controltovalidate="ForumNameInput" validationexpression="[^<>]+" display="dynamic" errormessage="The forum name must not contain any < or > characters." runat="server" />
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							Forum description:
						</td>
						<td>
							<asp:textbox id="ForumDescriptionInput" cssclass="forminput" tooltip="Forum description" rows="4" columns="40" textmode="MultiLine" runat="server" />
						</td>
						<td>
							<asp:requiredfieldvalidator id="ForumDescriptionRequired" cssclass="validator" controltovalidate="ForumDescriptionInput" display="dynamic" errormessage="To proceed, please enter a forum description.<br>" runat="server" />
							<asp:regularexpressionvalidator id="ForumDescriptionInvalidChars" cssclass="validator" controltovalidate="ForumDescriptionInput" validationexpression="[^<>]+" display="dynamic" errormessage="The forum description must not contain any < or > characters.<br>" runat="server" />
							<asp:regularexpressionvalidator id="ForumDescriptionMaxLength" cssclass="validator" controltovalidate="ForumDescriptionInput" validationexpression="(\S|\s){1,200}" display="dynamic" errormessage="The forum description must not exceed 200 characters.<br>" runat="server" />
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							Forum moderator (optional):
						</td>
						<td>
							<asp:dropdownlist id="ForumModeratorList" cssclass="forminput" datatextfield="fldMemberName" datavaluefield="fldMemberName" runat="server" />
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							Suspended:
						</td>
						<td>
							<asp:radiobutton id="SuspendForumNo" cssclass="forminput" groupname="SuspendForum" text="No" runat="server" />
							&nbsp;&nbsp;&nbsp;
							<asp:radiobutton id="SuspendForumYes" cssclass="forminput" groupname="SuspendForum" text="Yes" runat="server" />
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							&nbsp;
						</td>
						<td>
							<asp:button id="SaveForumButton" text="   Save   " CssClass="formbutton" runat="server" visible="True" onclick="SaveForum" />
							<input type="button" id="DeleteForumButton" name="DeleteForumButton" value=" Delete " class="formbutton" onclick="if (confirm('Active Data Online WebForum\n\nBy deleting a forum you will also delete all topics and messages associated with the forum.  Once deleted the forum\, topics and messages cannot be recovered.  Are you sure you would like to delete this forum?')){AdministerForumsForm.action='WF_Admin.aspx?area=forums&op=delete';AdministerForumsForm.submit();}">
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
				</table>
			</form>
		</asp:panel>
		<asp:panel id="TopicsPanel" runat="server">
			<form id="AdministerTopicsForm" name="AdministerTopicsForm" runat="server" action="WF_Admin.aspx?area=topics" method="post">
				<h2>
					Topics
				</h2>
				<asp:label id="ErrorInformationTopics" cssclass="error" visible="False" runat="server" />
				<table border="0" width="100%" cellspacing="5">
					<tr valign="top">
						<td>
							Current topic:
						</td>
						<td colspan="2">
							<asp:dropdownlist id="TopicsList" cssclass="forminput" datatextfield="formattedTopicDescription" datavaluefield="fldTopicID" onselectedindexchanged="SelectTopic" autopostback="True" runat="server" />
						</td>
					</tr>
					<tr valign="top">
						<td width="20%">
							Make read only:
						</td>
						<td width="40%">
							<asp:radiobutton id="ReadOnlyTopicNo" cssclass="forminput" groupname="ReadOnlyTopic" text="No" runat="server" />
							&nbsp;&nbsp;&nbsp;
							<asp:radiobutton id="ReadOnlyTopicYes" cssclass="forminput" groupname="ReadOnlyTopic" text="Yes" runat="server" />
						</td>
						<td width="40%">
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td width="20%">
							Suspend topic:
						</td>
						<td width="40%">
							<asp:radiobutton id="SuspendTopicNo" cssclass="forminput" groupname="SuspendTopic" text="No" runat="server" />
							&nbsp;&nbsp;&nbsp;
							<asp:radiobutton id="SuspendTopicYes" cssclass="forminput" groupname="SuspendTopic" text="Yes" runat="server" />
						</td>
						<td width="40%">
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							&nbsp;
						</td>
						<td>
							<asp:button id="SaveTopicButton" text="   Save   " CssClass="formbutton" runat="server" visible="True" onclick="SaveTopic" />
							<input type="button" id="DeleteTopicButton" name="DeleteTopicButton" value=" Delete " class="formbutton" onclick="if (confirm('Active Data Online WebForum\n\nBy deleting a topic you will also delete all messages associated with the topic.  Once deleted the topic and messages cannot be recovered.  Are you sure you would like to delete this topic?')){AdministerTopicsForm.action='WF_Admin.aspx?area=topics&fid=<%=Request.QueryString.Get("fid")%>&op=delete';AdministerTopicsForm.submit();}">
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
				</table>
			</form>
		</asp:panel>
		<asp:Panel id="IconsPanel" runat="server">
			<form id="AdministerIconsForm" runat="server" action="WF_Admin.aspx?area=icons" method="post" enctype="multipart/form-data">
				<h2>
					Icons
				</h2>
				<asp:label id="ErrorInformationIcons" cssclass="error" visible="False" runat="server" />
				<table border="0" width="100%" cellspacing="5">
					<tr valign="top">
						<td>
							Current icon:
						</td>
						<td colspan="2">
							<asp:dropdownlist id="IconsList" cssclass="forminput" datatextfield="formattedIconDescription" datavaluefield="fldIconID" runat="server" onselectedindexchanged="SelectIcon" autopostback="True" />
						</td>
					</tr>
					<tr valign="top">
						<td width="20%">
							Graphic:
						</td>
						<td width="40%">
							<asp:Image id="IconImage" AlternateText="No image" Runat="server" />
							<br>
							<input type="file" id="FileInput" name="FileInput" class="forminput" size="35" runat="server">
						</td>
						<td width="40%">
							<asp:regularexpressionvalidator id="ValidateFileType" cssclass="validator" controltovalidate="FileInput" ValidationExpression=".*\.gif|.*\.png|.*\.jpg|.*\.bmp" display="dynamic" errormessage="The current file type cannot be uploaded.<br />" runat="server" />
						</td>
					</tr>
					<tr valign="top">
						<td>
							Description:
						</td>
						<td colspan="2">
							<asp:textbox id="IconDescriptionInput" CssClass="forminput" Width="300" MaxLength="100" Runat="server" />
						</td>
					</tr>
					<tr valign="top">
						<td>
							&nbsp;
						</td>
						<td>
							<asp:button id="SaveIconButton" text="   Save   " CssClass="formbutton" runat="server" visible="True" onclick="SaveIcon" />
							<asp:button id="DeleteIconButton" text="  Delete " CssClass="formbutton" runat="server" visible="True" onclick="DeleteIcon" />
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
				</table>
			</form>
		</asp:Panel>
		<asp:panel id="MembersPanel" runat="server">
			<form id="AdministerMembersForm" runat="server" action="WF_Admin.aspx?area=members" method="post">
				<h2>
					Members
				</h2>
				<asp:label id="ErrorInformationMembers" cssclass="error" visible="False" runat="server" />
				<table border="0" width="100%" cellspacing="5">
					<tr valign="top">
						<td>
							Current member:
						</td>
						<td colspan="2">
							<asp:dropdownlist id="MembersList" cssclass="forminput" datatextfield="fldMemberName" datavaluefield="fldMemberName" runat="server" onselectedindexchanged="SelectMember" autopostback="True" />
						</td>
					</tr>
					<tr valign="top">
						<td width="20%">
							Member type:
						</td>
						<td width="40%">
							<asp:radiobutton id="MemberTypeUser" cssclass="forminput" groupname="MemberType" text="User" runat="server" />
							&nbsp;
							<asp:radiobutton id="MemberTypeModerator" cssclass="forminput" groupname="MemberType" text="Moderator" runat="server" />
						</td>
						<td width="40%">
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							Read only member:
						</td>
						<td>
							<asp:radiobutton id="ReadOnlyMemberNo" cssclass="forminput" groupname="ReadOnlyMember" text="No" runat="server" />
							&nbsp;&nbsp;&nbsp;
							<asp:radiobutton id="ReadOnlyMemberYes" cssclass="forminput" groupname="ReadOnlyMember" text="Yes" runat="server" />
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							Suspend member:
						</td>
						<td>
							<asp:radiobutton id="SuspendMemberNo" cssclass="forminput" groupname="SuspendMember" text="No" runat="server" />
							&nbsp;&nbsp;&nbsp;
							<asp:radiobutton id="SuspendMemberYes" cssclass="forminput" groupname="SuspendMember" text="Yes" runat="server" />
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
					<tr valign="top">
						<td>
							&nbsp;
						</td>
						<td>
							<asp:button id="SaveMemberButton" text="   Save   " CssClass="formbutton" runat="server" visible="True" onclick="SaveMember" />
						</td>
						<td>
							&nbsp;
						</td>
					</tr>
				</table>
			</form>
		</asp:panel>
		<asp:panel id="BannedWordsPanel" runat="server">
			<form id="AdministerBannedWordsForm" method="post" action="WF_Admin.aspx?area=bannedwords" runat="server">
				<h2>
					Words to censor
				</h2>
				<asp:datagrid id="BannedWordsGrid" onitemcommand="BannedWordsItemCommand" oneditcommand="EditBannedWords" oncancelcommand="CancelBannedWords" onupdatecommand="UpdateBannedWords" datakeyfield="fldWord" headerstyle-backcolor="darkblue" headerstyle-forecolor="white" bordercolor="black" cellpadding="5" autogeneratecolumns="False" runat="server">
					<columns>
						<asp:boundcolumn datafield="fldWord" headertext="Word" runat="server" />
						<asp:boundcolumn datafield="formattedCreated" itemstyle-font-size="8pt" headertext="Created" readonly="True" runat="server" />
						<asp:boundcolumn datafield="formattedUpdated" itemstyle-font-size="8pt" headertext="Updated" readonly="True" runat="server" />
						<asp:editcommandcolumn edittext="Edit" canceltext="Cancel" updatetext="Update" buttontype="LinkButton" headertext="" runat="server" />
						<asp:buttoncolumn buttontype="LinkButton" commandname="CommandDeleteBannedWord" text="Delete" headertext="" runat="server" />
					</columns>
				</asp:datagrid>
				<br>
				<asp:label id="NewWordLabel" text="New word: " cssclass="forminput" runat="server" />
				<asp:textbox id="NewBannedWord" width="150" runat="server" />
				<asp:button id="CommandAddBannedWord" commandname="CommandAddBannedWord" CssClass="formbutton" text="Add" onclick="AddBannedWords" runat="server" />
				<br>
			</form>
		</asp:panel>
		<br>
		<div class="small" id="ActiveDataOnline_Copyright" runat="server" />
	</body>
</html>
